<?php 
require_once('../include/Session.php');
require_once('../include/Functions.php');
require_once('../include/Crud.php');
require_once("../include/Controller.php");

$Controller = new Controller();

$user_id = $_SESSION['user_id'];

$current_form_number = 5;

$form_check_result = $Controller->fmCheckChurch($_SESSION['user_id']);

// Check if $form_check_result is not null and if it has at least one element
if ($form_check_result !== null && isset($form_check_result[0]['form_check'])) {
    $form_check = $form_check_result[0]['form_check'];

    // Cast $form_check to an integer
    $form_check = (int)$form_check;

    // var_dump($form_check); 
    if ($form_check === $current_form_number) {
        header("Location: ac.php");
        exit();
    }
}

$getAllZone = $Controller->getAllZone();
// var_dump($getAllZone);
// die();

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $zone =  stripslashes($_POST["zone"]);
    $church_att =  stripslashes($_POST["church_att"]);
    $na_of_pastor =  stripslashes($_POST["na_of_pastor"]);
    $na_of_cell =  stripslashes($_POST["na_of_cell"]);
    $cell_leader =  stripslashes($_POST["cell_leader"]);
    $cell_res =  stripslashes($_POST["cell_res"]);
    $yygba =  stripslashes($_POST["yygba"]);
    $yygba_where =  stripslashes($_POST["yygba_where"]);
    $yygbw =  stripslashes($_POST["yygbw"]);
    $yygbw_where =  stripslashes($_POST["yygbw_where"]);
    $found_sch =  stripslashes($_POST["found_sch"]);
    $year_min =  stripslashes($_POST["year_min"]);
    $em_in_love =  stripslashes($_POST["em_in_love"]);
    $em_in_hs =  stripslashes($_POST["em_in_hs"]);
    $user_id =  $_POST["user_id"];
    try {
        $data = [
            "form_check" => 5,
            "zone" => $zone,
            "church_att" => $church_att,
            "na_of_pastor" => $na_of_pastor,
            "na_of_cell" => $na_of_cell,
            "cell_leader" => $cell_leader,
            "cell_res" => $cell_res,
            "yygba" => $yygba,
            "yygba_where" => $yygba_where,
            "yygbw" => $yygbw,
            "yygbw_where" => $yygbw_where,
            "found_sch" => $found_sch,
            "year_min" => $year_min,
            "em_in_love" => $em_in_love,
            "em_in_hs" => $em_in_hs,
            "user_id" => $user_id,
        ];

        $lastInsertedId = $Controller->createChurch($data);
        if ($lastInsertedId) {
            $_SESSION['church_id'] = $lastInsertedId;
            $_SESSION['staff_church'] = true;
        
            $_SESSION["successMsg"] = "Successfully registered";
            // JavaScript code to redirect after 5 seconds
            echo '<script>
                    setTimeout(function() {
                        window.location.href = "ac.php"; 
                    }, 1000); 
                  </script>';
            exit(); // Ensure no further PHP code is executed
        }
        
    } catch (PDOException $e) {
        // Handle database errors
        $_SESSION['errorMsg'] = "Database error: " . $e->getMessage();
      } catch (Exception $e) {
        // Handle unexpected exceptions
        $_SESSION['errorMsg'] = "An unexpected error occurred: " . $e->getMessage();
      }
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <title>Healing School | Staff Portal</title>
    <meta name="viewport" content="width=device-width,initial-scale=1,shrink-to-fit=no" />
    <meta content="Staff Portal For Healing School" name="description" />
    <meta content="" name="author" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <!-- App favicon -->
    <link rel="shortcut icon" href="assets/images/favicon.ico" />
    <!--Form Wizard-->
    <link rel="stylesheet" href="../plugins/jquery-steps/jquery.steps.css" />
    <!-- App css -->
    <link href="assets/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
    <link href="assets/css/jquery-ui.min.css" rel="stylesheet" />
    <link href="assets/css/icons.min.css" rel="stylesheet" type="text/css" />
    <link href="assets/css/metisMenu.min.css" rel="stylesheet" type="text/css" />
    <link href="../plugins/daterangepicker/daterangepicker.css" rel="stylesheet" type="text/css" />
    <link href="assets/css/app.min.css" rel="stylesheet" type="text/css" />
    <link href="../plugins/timepicker/bootstrap-material-datetimepicker.css" rel="stylesheet" />
</head>

<body class="dark-sidenav">
    <!-- Left Sidenav -->
    <?php
    include_once ("../components/sidenav.php");
    ?>
    <!-- end left-sidenav-->
    <div class="page-wrapper">
        <!-- Top Bar Start -->
        <?php
        include_once ("../components/topbar.php"); 
        ?>

        <!-- Top Bar End --><!-- Page Content-->
        <div class="page-content">
            <div class="container-fluid">
                <!-- Page-Title -->
                <div class="row">
                    <div class="col-sm-12">
                        <div class="page-title-box">
                            <div class="row">
                                <div class="col">
                                    <h4 class="page-title">Staff Portal</h4>
                                    <ol class="breadcrumb">

                                        <li class="breadcrumb-item">
                                            <a href="javascript:void(0);">Staff Portal</a>
                                        </li>
                                        <li class="breadcrumb-item active">Forms</li>
                                    </ol>
                                </div>
                                <!--end col-->
                                <div class="col-auto align-self-center">
                                    <a href="#" class="btn btn-sm btn-outline-primary" id="Dash_Date"><span class="day-name" id="Day_Name">Today:</span>&nbsp;
                                        <span class="" id="Select_date">Jan 11</span>
                                        <i data-feather="calendar" class="align-self-center icon-xs ml-1"></i> </a>
                                </div>
                                <!--end col-->
                            </div>
                            <!--end row-->
                        </div>
                        <!--end page-title-box-->
                    </div>
                    <!--end col-->
                </div>
                <!--end row--><!-- end page title end breadcrumb -->
                <?php
                echo errorMsg();
                echo successMsg();
                echo infoMsg();

                ?>
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-header">
                                <h4 class="card-title">Staff Form</h4>
                                <p class="text-muted mb-0">Please ensure all details are filled out before submitting.
                                    <i class="mdi mdi-heart text-danger"></i>

                                </p>
                            </div>
                            <!--end card-header-->
                            <div class="card-body">
                                <form id="form-horizontal form" class="form-horizontal form-wizard-wrapper" method="POST">

                                    <h3>Church</h3>
                                    <fieldset>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group row">
                                                    <label for="" class="col-lg-3 col-form-label">Zone</label>
                                                    <div class="col-lg-9">
                                                        <select name="zone" id="" class="form-control" required >
                                                            <option value="0" selected disabled>Select Zone</option>
                                                            <?php foreach ($getAllZone as $zone) {
                                                            ?>
                                                            <option value="<?=$zone['zoneId']?>"><?=$zone['zone']?></option>
                                                            <?php }?>
                                                        </select>
                                                    </div>
                                                </div>
                                                <!--end form-group-->
                                            </div>
                                            <!--end col-->
                                            <div class="col-md-6">
                                                <div class="form-group row">
                                                    <label for="" class="col-lg-3 col-form-label">Church You Attend</label>
                                                    <div class="col-lg-9">
                                                        <input id="" name="church_att" type="text" class="form-control" required/>
                                                    </div>
                                                </div>
                                                <!--end form-group-->
                                            </div>
                                            <!--end col-->
                                        </div>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group row">
                                                    <label for="" class="col-lg-3 col-form-label">Name of Pastor</label>
                                                    <div class="col-lg-9">
                                                        <input id="" name="na_of_pastor" type="text" class="form-control" required/>
                                                    </div>
                                                </div>
                                                <!--end form-group-->
                                            </div>
                                            <!--end col-->
                                            <div class="col-md-6">
                                                <div class="form-group row">
                                                    <label for="" class="col-lg-3 col-form-label">Name of Cell </label>
                                                    <div class="col-lg-9">
                                                        <input id="" name="na_of_cell" type="text" class="form-control" required/>
                                                    </div>
                                                </div>
                                                <!--end form-group-->
                                            </div>
                                            <!--end col-->
                                        </div>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group row">
                                                    <label for="" class="col-lg-3 col-form-label">Cell Leader</label>
                                                    <div class="col-lg-9">
                                                        <input id="" name="cell_leader" type="text" class="form-control" required/>
                                                    </div>
                                                </div>
                                                <!--end form-group-->
                                            </div>
                                            <!--end col-->
                                            <div class="col-md-6">
                                                <div class="form-group row">
                                                    <label for="" class="col-lg-3 col-form-label">Cell Responsibility </label>
                                                    <div class="col-lg-9">
                                                        <input id="" name="cell_res" type="text" class="form-control" required/>
                                                    </div>
                                                </div>
                                                <!--end form-group-->
                                            </div>
                                            <!--end col-->
                                        </div>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group row">
                                                    <label for="" class="col-lg-3 col-form-label">Year you got Born Again</label>
                                                    <div class="col-lg-9">
                                                        <input id="" name="yygba" type="date" class="form-control" required/>
                                                    </div>
                                                </div>
                                                <!--end form-group-->
                                            </div>
                                            <!--end col-->
                                            <div class="col-md-6">
                                                <div class="form-group row">
                                                    <label for="" class="col-lg-3 col-form-label">Where</label>
                                                    <div class="col-lg-9">
                                                        <input id="" name="yygba_where" type="text" class="form-control" required/>
                                                    </div>
                                                </div>
                                                <!--end form-group-->
                                            </div>
                                            <!--end col-->
                                        </div>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group row">
                                                    <label for="" class="col-lg-3 col-form-label">Year you got Baptized in Water</label>
                                                    <div class="col-lg-9">
                                                        <input id="" name="yygbw" type="date" class="form-control" required/>
                                                    </div>
                                                </div>
                                                <!--end form-group-->
                                            </div>
                                            <!--end col-->
                                            <div class="col-md-6">
                                                <div class="form-group row">
                                                    <label for="" class="col-lg-3 col-form-label">Where</label>
                                                    <div class="col-lg-9">
                                                        <input id="" name="yygbw_where" type="text" class="form-control" required/>
                                                    </div>
                                                </div>
                                                <!--end form-group-->
                                            </div>
                                            <!--end col-->
                                        </div>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group row">
                                                    <label for="" class="col-lg-3 col-form-label">Foundation School</label>
                                                    <div class="col-lg-9">
                                                        <input id="" name="found_sch" type="text" class="form-control" required/>
                                                    </div>
                                                </div>
                                                <!--end form-group-->
                                            </div>
                                            <!--end col-->
                                            <div class="col-md-6">
                                                <div class="form-group row">
                                                    <label for="" class="col-lg-3 col-form-label">Year You Joined The Ministry</label>
                                                    <div class="col-lg-9">
                                                        <input id="" name="year_min" type="date" class="form-control" required/>
                                                    </div>
                                                </div>
                                                <!--end form-group-->
                                            </div>
                                            <!--end col-->
                                        </div>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group row">
                                                    <label for="" class="col-lg-3 col-form-label">Employment into Loveworld Incorporated</label>
                                                    <div class="col-lg-9">
                                                        <input id="" name="em_in_love" type="date" class="form-control" required/>
                                                    </div>
                                                </div>
                                                <!--end form-group-->
                                            </div>
                                            <!--end col-->
                                            <div class="col-md-6">
                                                <div class="form-group row">
                                                    <label for="" class="col-lg-3 col-form-label">Employment into the Healing School</label>
                                                    <div class="col-lg-9">
                                                        <input id="" name="em_in_hs" type="date" class="form-control" required/>
                                                    </div>
                                                </div>
                                                <!--end form-group-->
                                            </div>
                                            <!--end col-->
                                            <div class="col-md-6">
                                                <div class="form-group row">
                                                    <div class="col-lg-9">
                                                        <input id="" value="<?=$_SESSION['user_id']?>" name="user_id" type="hidden" class="form-control" />
                                                    </div>
                                                </div>
                                                <!--end form-group-->
                                            </div>
                                        </div>
                                    </fieldset>
                                    <div class="button-items" style="float:right">
                                        <script>
                                            // Function to store the current page URL in session storage
                                            function storePreviousPage() {
                                                sessionStorage.setItem('previousPage', window.location.href);
                                            }

                                            // Function to redirect the user to the previous page
                                            function redirectToPreviousPage() {
                                                var previousPage = sessionStorage.getItem('previousPage');
                                                if (previousPage) {
                                                    window.location.href = previousPage;
                                                } else {
                                                    window.location.href = '../index.php';
                                                }
                                            }
                                        </script>

                                        <button type="button" class="btn btn-outline-secondary btn-square btn-skew waves-effect waves-light" onclick="redirectToPreviousPage()">
                                            <span>Previous</span>
                                        </button>
                                        <button type="submit" class="btn btn-outline-primary btn-square btn-skew waves-effect waves-light" onclick="storePreviousPage(); document.getElementById('form').submit();">
                                            <span>Next</span>
                                        </button>

                                    </div>
                                    <!--end fieldset-->
                                </form>
                                <!--end form-->
                            </div>
                            <!--end card-body-->
                        </div>
                        <!--end card-->
                    </div>
                    <!--end col-->
                </div>
                <!--end row-->

                <!--end row-->
            </div>
            <!-- container -->
            <?php include_once('../components/footer.php') ?>
            <!--end footer-->
        </div>
        <!-- end page content -->
    </div>
    <!-- end page-wrapper --><!-- jQuery  -->
    <script src="assets/js/jquery.min.js"></script>
    <script src="assets/js/bootstrap.bundle.min.js"></script>
    <script src="assets/js/metismenu.min.js"></script>
    <script src="assets/js/waves.js"></script>
    <script src="assets/js/feather.min.js"></script>
    <script src="assets/js/simplebar.min.js"></script>
    <script src="assets/js/jquery-ui.min.js"></script>
    <script src="assets/js/moment.js"></script>
    <script src="../plugins/daterangepicker/daterangepicker.js"></script>

    <!-- App js -->
    <script src="assets/js/app.js"></script>
</body>

</html>