<?php
require_once('Crud.php');

class Controller
{
    private $crud;

    public function __construct()
    {
        $this->crud = new Crud();
    }

    public function registerUser($data)
    {
        $table = "users";
        $lastInsertedId = $this->crud->create($data, $table);
        return $lastInsertedId;
    }
    public function registerAcc($data)
    {
        $table = "accomadation";
        $lastInsertedId = $this->crud->create($data, $table);
        return $lastInsertedId;
    }
    public function createChurch($data)
    {
        $table = "church";
        $lastInsertedId = $this->crud->create($data, $table);
        return $lastInsertedId;
    }
    public function createOd($data)
    {
        $table = "other_details";
        $lastInsertedId = $this->crud->create($data, $table);
        return $lastInsertedId;
    }
    public function createFam($data)
    {
        $table = "family";
        $lastInsertedId = $this->crud->create($data, $table);
        return $lastInsertedId;
    }
    public function createEdu($data)
    {
        $table = "education";
        $lastInsertedId = $this->crud->create($data, $table);
        return $lastInsertedId;
    }
    public function createWH($data)
    {
        $table = "work_history";
        $lastInsertedId = $this->crud->create($data, $table);
        return $lastInsertedId;
    }
    public function createWhTwo($data)
    {
        $table = " work_history_two";
        $lastInsertedId = $this->crud->create($data, $table);
        return $lastInsertedId;
    }
    public function isUserRegistered($email, $conn, $kc_username)
    {
        try {
            $query = "SELECT COUNT(*) FROM users WHERE email = :email AND kc_username = :kc_username";

            $stmt = $conn->prepare($query);
            $stmt->bindParam(':email', $email);
            $stmt->bindParam(':kc_username', $kc_username);
            $stmt->execute();

            $count = $stmt->fetchColumn();

            return $count > 0;
        } catch (PDOException $e) {
            // Handle database query errors here
            return false;
        }
    }
    public function verifyUser($kc_username, $password)
    {
        $sql = "SELECT * FROM users WHERE kc_username = :kc_username";
        $params = array(':kc_username' => $kc_username);
    
        try {
            $result = $this->crud->read($sql, $params);
    
            if ($result && count($result) === 1) {
                $row = $result[0]; // Get the first row
                $storedPassword = $row['password']; // Get the stored password from the database
    
                // Check if the stored password is hashed
                if (password_verify($password, $storedPassword)) {
                    return $row; // Return user data
                } elseif ($password === $storedPassword) {
                    // Password matches without hashing
                    return $row; // Return user data
                } else {
                    // Incorrect password
                    return "Incorrect password";
                }
            } elseif ($result && count($result) === 0) {
                // User not found
                return "Invalid username or password";
            } else {
                // Handle database query error
                return "Database error";
            }
        } catch (Exception $e) {
            // Handle any exceptions that may occur during database interaction
            return "Error: " . $e->getMessage();
        }
    }
    
    public function getUserById($user_id)
    {
        $sql = "SELECT * FROM users WHERE user_id = :user_id";
        $params = array(
            ':user_id' => $user_id,

        );
        return $this->crud->read($sql, $params);
    }
    
    public function updateUser($user_id, $title, $first_name, $middle_name, $last_name, $phone_no, $kc_username, $email, $off_email, $esp_username, $d_o_b, $form_check)
    {
        $sql = "UPDATE users 
                    SET title = :title,
                        first_name = :first_name,
                        middle_name = :middle_name,
                        last_name = :last_name,
                        phone_no = :phone_no,
                        kc_username = :kc_username,
                        email = :email,
                        off_email = :off_email,
                        esp_username = :esp_username,
                        d_o_b = :d_o_b,
                        form_check = :form_check
                    WHERE user_id = :user_id";
    
        $params = array(
            ':title' => $title,
            ':first_name' => $first_name,
            ':middle_name' => $middle_name,
            ':last_name' => $last_name,
            ':phone_no' => $phone_no,
            ':kc_username' => $kc_username,
            ':email' => $email,
            ':off_email' => $off_email,
            ':form_check' => $form_check,
            ':esp_username' => strtoupper($esp_username),
            ':d_o_b' => date('Y-m-d', strtotime($d_o_b)),
            ':user_id' => $user_id
        );
    
        $this->crud->update($sql, $params);
    }
    
    
    // public function fmCheckSd()
    // {
    //     $query = "SELECT * FROM `users` WHERE `form_check` = 1";
    //     return $this->crud->read($query);
    // }
    public function fmCheckSd($user_id)
    {
        $query = "SELECT form_check FROM users WHERE user_id = :user_id LIMIT 1";
        return $this->crud->read($query, ['user_id' => $user_id]);
    }
    
    public function fmCheckEd($user_id)
    {
        $query = "SELECT form_check FROM education WHERE user_id = :user_id LIMIT 1";
        return $this->crud->read($query, ['user_id' => $user_id]);
    }
    
    public function fmCheckWh($user_id)
    {
        $query = "SELECT form_check FROM work_history WHERE user_id = :user_id LIMIT 1";
        return $this->crud->read($query, ['user_id' => $user_id]);
    }
    public function fmCheckWhTwo($user_id)
    {
        $query = "SELECT form_check FROM work_history_two WHERE user_id = :user_id LIMIT 1";
        return $this->crud->read($query, ['user_id' => $user_id]);
    }
    public function fmCheckChurch($user_id)
    {
        $query = "SELECT form_check FROM church WHERE user_id = :user_id LIMIT 1";
        return $this->crud->read($query, ['user_id' => $user_id]);
    }
    public function fmCheckAccomadation($user_id)
    {
        $query = "SELECT form_check FROM accomadation WHERE user_id = :user_id LIMIT 1";
        return $this->crud->read($query, ['user_id' => $user_id]);
    }
    public function fmCheckFamily($user_id)
    {
        $query = "SELECT form_check FROM family WHERE user_id = :user_id LIMIT 1";
        return $this->crud->read($query, ['user_id' => $user_id]);
    }
    public function fmCheckOd($user_id)
    {
        $query = "SELECT form_check FROM other_details WHERE user_id = :user_id LIMIT 1";
        return $this->crud->read($query, ['user_id' => $user_id]);
    }
    

    public function getAllZone()
    {
        $query = "SELECT * FROM zones";
        return $this->crud->read($query);
    }
   
    
    
}