<?php 


function getUserDetails($db)
{
	
	//initial query
	$query = "Select kc_id, user_name, user_image from kc_user";
	
	$query_params = array(
			  
		);
		
	//execute query
	try {
		$stmt   = $db->prepare($query);
		$result = $stmt->execute($query_params);
	}
	catch (PDOException $ex) {
		 $response["success"] = 0;
       // $response["message"] = "Unable to check for users. Please try again later";
         $response["message"] = "Unable to add";//.$ex->getMessage();
	}
	
	// Finally, we can retrieve all of the found rows into an array using fetchAll 
	$rows = $stmt->fetchAll();
	
	
	if ($rows) {
		$response["success"] = 1;
        $response["message"] = "User found";
        $response["rows"]   = $rows;
    
   	} 
	else
	{
	 $response["success"] = 0;
    $response["message"] = "No user found";	
	}
	return $response;	
}//end getMeetings

function getStaffBio($db)
{
	
	//initial query
	$query = "Select kc_id, title, first_name, last_name, staffweek from users where staffweek > 0";
	
	$query_params = array(
			  
		);
		
	//execute query
	try {
		$stmt   = $db->prepare($query);
		$result = $stmt->execute($query_params);
	}
	catch (PDOException $ex) {
		 $response["success"] = 0;
       // $response["message"] = "Unable to check for users. Please try again later";
         $response["message"] = "Unable to add";//.$ex->getMessage();
	}
	
	// Finally, we can retrieve all of the found rows into an array using fetchAll 
	$rows = $stmt->fetchAll();
	
	
	if ($rows) {
		$response["success"] = 1;
        $response["message"] = "User found";
        $response["rows"]   = $rows;
    
   	} 
	else
	{
	 $response["success"] = 0;
    $response["message"] = "No user found";	
	}
	return $response;	
}//end getMeetings

function getZonalPastors($db)
{
	
	//initial query
	$query = "Select * from zonal_pastors ";
	
	$query_params = array(
			  
		);
		
	//execute query
	try {
		$stmt   = $db->prepare($query);
		$result = $stmt->execute($query_params);
	}
	catch (PDOException $ex) {
		 $response["success"] = 0;
       // $response["message"] = "Unable to check for users. Please try again later";
         $response["message"] = "Unable to add".$ex->getMessage();
	}
	
	// Finally, we can retrieve all of the found rows into an array using fetchAll 
	$rows = $stmt->fetchAll();
	
	
	if ($rows) {
		$response["success"] = 1;
        $response["message"] = "User found";
        $response["rows"]   = $rows;
    
   	} 
	else
	{
	 $response["success"] = 0;
    $response["message"] = "No user found";	
	}
	return $response;	
}//end getMeetings

function getBLWPastors($db)
{
	
	//initial query
	$query = "Select * from blw_pastors ";
	
	$query_params = array(
			  
		);
		
	//execute query
	try {
		$stmt   = $db->prepare($query);
		$result = $stmt->execute($query_params);
	}
	catch (PDOException $ex) {
		 $response["success"] = 0;
       // $response["message"] = "Unable to check for users. Please try again later";
         $response["message"] = "Unable to add".$ex->getMessage();
	}
	
	// Finally, we can retrieve all of the found rows into an array using fetchAll 
	$rows = $stmt->fetchAll();
	
	
	if ($rows) {
		$response["success"] = 1;
        $response["message"] = "User found";
        $response["rows"]   = $rows;
    
   	} 
	else
	{
	 $response["success"] = 0;
    $response["message"] = "No user found";	
	}
	return $response;	
}//end getMeetings

function getHsList($db, $offset)
{
	echo "offset: $offset";
	//initial query
	$query = "Select * from list LIMIT $offset, 50 ";
	
	$query_params = array(
            //':offset' => $offset,
		);
		
	//execute query
	try {
		$stmt   = $db->prepare($query);
		$result = $stmt->execute($query_params);
	}
	catch (PDOException $ex) {
		 $response["success"] = 0;
       // $response["message"] = "Unable to check for users. Please try again later";
         $response["message"] = "Unable to add".$ex->getMessage();
	}
	
	// Finally, we can retrieve all of the found rows into an array using fetchAll 
	$rows = $stmt->fetchAll();
	
	
	if ($rows) {
		$response["success"] = 1;
        $response["message"] = "User found";
        $response["rows"]   = $rows;
    
   	} 
	else
	{
	 $response["success"] = 0;
    $response["message"] = "No user found";	
	}
	return $response;	
}//end getMeetings

function getIclcList($db, $offset)
{
	echo "offset: $offset";
	//initial query
	$query = "Select * from iclc2024 LIMIT $offset, 50 ";
	
	$query_params = array(
            //':offset' => $offset,
		);
		
	//execute query
	try {
		$stmt   = $db->prepare($query);
		$result = $stmt->execute($query_params);
	}
	catch (PDOException $ex) {
		 $response["success"] = 0;
       // $response["message"] = "Unable to check for users. Please try again later";
         $response["message"] = "Unable to add".$ex->getMessage();
	}
	
	// Finally, we can retrieve all of the found rows into an array using fetchAll 
	$rows = $stmt->fetchAll();
	
	
	if ($rows) {
		$response["success"] = 1;
        $response["message"] = "User found";
        $response["rows"]   = $rows;
    
   	} 
	else
	{
	 $response["success"] = 0;
    $response["message"] = "No user found";	
	}
	return $response;	
}//end getMeetings


function updateZone($db, $kc_id, $user_name, $user_image)
{
	
	//initial query
	$query = "UPDATE users set kc_id = :kc_id, kc_picture = :user_image where kc_username = :user_name";
	
	$query_params = array(
			 ':kc_id' => $kc_id,
            ':user_image' => $user_image,
        ':user_name' => $user_name,
			
		);
		
	//execute query
	try {
		$stmt   = $db->prepare($query);
		$result = $stmt->execute($query_params);
	}
	catch (PDOException $ex) {
		 $response["success"] = 0;
    $response["message"] = "Error in updating".$ex->getMessage();
	return $response;	
	}
	
	$response["success"] = 1;
    $response["message"] = "User updated";// $userId, $videoMinutes";
    
	return $response;	
}//end update dispatch

function updateMailSend($db, $user_id, $action_user_id)
{
	
	//initial query
	$query = "UPDATE messages set started = 1 where user_id = :user_id and action_user_id = :action_user_id";
	
	$query_params = array(
			 ':user_id' => $user_id,
            ':action_user_id' => $action_user_id,
			
		);
		
	//execute query
	try {
		$stmt   = $db->prepare($query);
		$result = $stmt->execute($query_params);
	}
	catch (PDOException $ex) {
		 $response["success"] = 0;
    $response["message"] = "Error in updating";//.$ex->getMessage();
	return $response;	
	}
	
	$response["success"] = 1;
    $response["message"] = "Message updated";// $userId, $videoMinutes";
    
	return $response;	
}//end update dispatch

function preRegister($db, $userId, $streamId){
    //initial query
	$query = "INSERT INTO pre_registration (stream_id, user_id) VALUES (:streamId, :userId) ON DUPLICATE KEY UPDATE updated_at = NOW()";
	
	$query_params = array(
			 ':userId' => $userId,
            ':streamId' => $streamId,
			
		);
		
	//execute query
	try {
		$stmt   = $db->prepare($query);
		$result = $stmt->execute($query_params);
	}
	catch (PDOException $ex) {
		 $response["success"] = 0;
    $response["message"] = "Unable to register 2";//.$ex->getMessage();
	return $response;	
	}
	
	$response["success"] = 1;
    $response["message"] = "Thank you for registering";// $userId, $videoMinutes";
    
	return $response;	
}

function preRegisterApprove($db, $preregId){
    //initial query
	$query = "UPDATE pre_registration set approved = 1 WHERE id = :preregId LIMIT 1";
	
	$query_params = array(
			 ':preregId' => $preregId,
			
		);
		
	//execute query
	try {
		$stmt   = $db->prepare($query);
		$result = $stmt->execute($query_params);
	}
	catch (PDOException $ex) {
		 $response["success"] = 0;
    $response["message"] = "Unable to approve";//.$ex->getMessage();
	return $response;	
	}
	
	$response["success"] = 1;
    $response["message"] = "Approved!";// $userId, $videoMinutes";
    
	return $response;	
}

?>

