<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('ministry_profiles', function (Blueprint $table) {
            //
            $table->string('group')->nullable()->after('church');
            $table->string('group_pastor')->nullable()->after('church');
            $table->string('zonal_pastor')->nullable()->after('zone');
            $table->string('cell_name')->nullable()->after('pastor');
            $table->string('care_group_name')->nullable()->after('cell_responsibility');
            $table->string('care_group_role')->nullable()->after('cell_responsibility');
            $table->string('care_group_leader')->nullable()->after('cell_responsibility');
            $table->string('care_group_venue')->nullable()->after('cell_responsibility');

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('ministry_profiles', function (Blueprint $table) {
            //
        });
    }
};
