<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">
    <meta name="description" content="Ministry Reporting Solution">
    <meta name="keywords" content="christ,embassy,report,finance">
    <meta name="author" content="<?php echo e(env('DEV')); ?>">
    <meta name="robots" content="noindex, nofollow">
    <title>Login - <?php echo e(env('APP_NAME')); ?></title>

    <!-- Favicon -->
    <link rel="shortcut icon" type="image/x-icon" href="<?php echo e(url('assets/images/logo.png')); ?>">

    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="<?php echo e(url('assets/css/bootstrap.min.css')); ?>">

    <!-- Fontawesome CSS -->
    <link rel="stylesheet" href="<?php echo e(url('assets/css/font-awesome.min.css')); ?>">

    <!-- Main CSS -->
    <link rel="stylesheet" href="<?php echo e(url('assets/css/style.css')); ?>">

    <!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!--[if lt IE 9]>
    <script src="<?php echo e(url('assets/js/html5shiv.min.js')); ?>"></script>
    <script src="<?php echo e(url('assets/js/respond.min.js')); ?>"></script>
    <![endif]-->

</head>
<body class="account-page">

<!-- Main Wrapper -->
<div class="main-wrapper">
    <div class="account-content">
        <div class="container">

            <!-- Account Logo -->
            <div class="account-logo">
                <a href="<?php echo e(route('login')); ?>"><img src="<?php echo e(url('assets/images/logo.png')); ?>" alt=""></a>
            </div>
            <!-- /Account Logo -->

            <div class="account-box">
                <div class="account-wrapper">
                    <h3 class="account-title">Login with your KingsChat Credentials</h3>

                    <?php if(session('error')): ?>
                    <div class="alert alert-danger"><?php echo e(session('error')); ?></div>
                    <?php endif; ?>

                    <!-- Account Form -->

                        <div class="form-group  mt-5 text-center">
                            <a href="https://accounts.kingsch.at/?client_id=com.kingschat&scopes=[%22conference_calls%22]&post_redirect=true&redirect_uri=<?php echo e(route('authLogin')); ?>" class="btn btn-outline-primary btn-block">
                                <img src="https://kingsch.at/h/css/images/favicon.ico" alt="">
                                Login with KingsChat
                            </a>
                        </div>


                </div>
            </div>
        </div>
    </div>
</div>
<!-- /Main Wrapper -->

<!-- jQuery -->
<script src="<?php echo e(url('assets/js/jquery-3.5.1.min.js')); ?>"></script>

<!-- Bootstrap Core JS -->
<script src="<?php echo e(url('assets/js/popper.min.js')); ?>"></script>
<script src="<?php echo e(url('assets/js/bootstrap.min.js')); ?>"></script>

<!-- Custom JS -->
<script src="<?php echo e(url('assets/js/app.js')); ?>"></script>

</body>
</html>
<?php /**PATH C:\xampp\htdocs\dashboard\PROJECTS\hshrp\resources\views/authentication/login.blade.php ENDPATH**/ ?>